import java.io.*;

public class Sample
{
    public static void main(String[] args)
    {
    	int  iRetcode, iSelect = 0, iBlock_index;
    	int iTmp;
    	int  iHandle;
    	int[]  iUid = new int[1], iHid = new int[1];
    	byte[] cBuffer = new byte[512], cTmp = new byte[20];
    	String strTmp;
    	
    	System.out.print("Begin the program");
    	
		JRockey2 rockey=new JRockey2();		
    	do
		{
	    	System.out.println();
	    	System.out.println("1. Generate UID");
	    	System.out.println("2. Write Rockey2");
	    	System.out.println("3. Read Rockey2");
	    	System.out.println("4. Exit");
	    	System.out.print("Please input select: ");
			try
			{
	    		iSelect = System.in.read();
	    		do
	    		{
	    			iTmp = System.in.read();
	    		}while(iTmp != 0xa);
	    		iSelect -= 0x30;
			}
			catch(Exception e)
			{
				System.out.println("Can't Read");
				return;
			}
            if(iSelect == 1)
            {
            	iRetcode = rockey.RY2_Find();
            	if(iRetcode < 0)
            	{
            	    System.out.println("ERROR: " + Integer.toHexString(iRetcode));
            	    return;
            	}
            	if(iRetcode == 0)
            	{
            	    System.out.println("ERROR: Not found any rockey2");
            	    return;
            	}

				// when generate UID, only one dongle should be inserted to computer
				// so we do not cared what UID and HID is. 
				// we just use the dongle we find fisrt.
     	      	iRetcode = rockey.RY2_Open(rockey.AUTO_MODE, 0, iHid);
           		if(iRetcode < 0)
        	   	{
        	   	    System.out.println("ERROR: " + Integer.toHexString(iRetcode));
        	   	    return;
        	   	}

        	   	iHandle = iRetcode;

         	  	System.out.print("Please input seed: ");
         	  	try
         	  	{         
         	  		iTmp = System.in.read(cBuffer, 0, 512);
         	  		
         	  		// delete carriages.
         	  		if(cBuffer[iTmp-1] == 0xa)
         	  		{
         	  			cBuffer[iTmp-1] = 0;
         	  			cBuffer[iTmp-2] = 0;
         	  		}
         	  	}
         	  	catch(Exception e)
         	  	{
         	  		System.out.println("Read Error!");
         	  		return;
         	  	}

        	   	iRetcode = rockey.RY2_GenUID(iHandle, iUid, cBuffer, rockey.ROCKEY2_DISABLE_WRITE_PROTECT);
 				if (iRetcode < 0)
				{
		  			System.out.println("ERROR: " + Integer.toHexString(iRetcode));
				    return;
				}

				System.out.println("\nUID is " + iUid[0]);
				rockey.RY2_Close(iHandle);

				// after generating a new UID, the flag of dongle will change, we have to re-plug it
				System.out.println("You must plug out Rockey2 and re-plug to enable new uid.");
	  		}

            // use specific UID to write to dongle
	    	if (iSelect == 2)
	   	 	{
				iRetcode = rockey.RY2_Find();
				if (iRetcode < 0)
				{
				    System.out.println("ERROR: " + Integer.toHexString(iRetcode));
				    return;
				}
				if (iRetcode == 0)
				{
				    System.out.println("ERROR: Not found any rockey2");
				    return;
				}

				System.out.print("please input uid : ");
				try
				{
					iTmp = System.in.read(cTmp);
					
					// delete carriages.
					cTmp[iTmp-1]=0;
					cTmp[iTmp-2]=0;

					// translate the content in buffer into string, and into int
					strTmp = new String(cTmp, 0, iTmp-2);
					iUid[0] = new Integer(strTmp).intValue();
				}
				catch(Exception e)
				{
					System.out.println("Read uid error");
					return;
				}
				
				iRetcode = rockey.RY2_Open(1, iUid[0], iHid);
				if (iRetcode < 0)
				{
					System.out.println("ERROR: " + iRetcode);
					return;
				}
				iHandle = iRetcode;
				System.out.print("Please input write block index(0-4) : ");
				try
				{
					iBlock_index = System.in.read();
					// delete carriages
					do
					{
						iTmp = System.in.read();
					}while(iTmp != 0xa);
					iBlock_index -= 0x30;
				}
				catch(Exception e)
				{
					System.out.println("Read block index error");
					return;
				}
				System.out.print("Please input write data : ");
				try
				{
					iTmp = System.in.read(cBuffer);
					// delete carriages
					cBuffer[iTmp-1] = 0;
					cBuffer[iTmp-2] = 0;
				}
				catch(Exception e)
				{
					System.out.println("Read buffer error");
					return;
				}
				
				iRetcode = rockey.RY2_Write(iHandle, iBlock_index, cBuffer);
				if (iRetcode < 0)
				{
					System.out.println("ERROR: " + Integer.toHexString(iRetcode));
					return;
				}
				System.out.println("Write OK");
				rockey.RY2_Close(iHandle);
   			}

            		// use specific UID to read from dongle
   			if (iSelect == 3)
			{
				iRetcode = rockey.RY2_Find();
				if (iRetcode < 0)
				{
					System.out.println("ERROR: " + Integer.toHexString(iRetcode));
					return;
				}
				if (iRetcode == 0)
				{
					System.out.println("ERROR: Not found any rockey2");
					return;
				}

				System.out.print("please input uid : ");
				try
				{
					iTmp = System.in.read(cTmp);
					cTmp[iTmp-1]=0;
					cTmp[iTmp-2]=0;
					strTmp = new String(cTmp, 0, iTmp-2);
					iUid[0] = new Integer(strTmp).intValue();
				}
				catch(Exception e)
				{
					System.out.println("Read uid error");
					return;
				}
				iRetcode = rockey.RY2_Open(1, iUid[0], iHid);
				if (iRetcode < 0)
				{
					System.out.println("ERROR: " + Integer.toHexString(iRetcode));
					return;
				}
				iHandle = iRetcode;

				System.out.print("Please input read block index(0-4) : ");
				try
				{
					iBlock_index = System.in.read();
					// delete carriages
					do
					{
						iTmp = System.in.read();
					}while(iTmp != 0xa);
					iBlock_index -= 0x30;
				}
				catch(Exception e)
				{
					System.out.println("Read block index error");
					return;
				}
				iRetcode = rockey.RY2_Read(iHandle, iBlock_index, cBuffer);
				if (iRetcode < 0)
				{
					System.out.println("ERROR: " + Integer.toHexString(iRetcode));
					return;
				}
				System.out.println("Readed data: " + (new String(cBuffer, 0, BufLen(cBuffer, 512))));
				rockey.RY2_Close(iHandle);
			}
		} while(iSelect != 4);
  	}
  	
  	// find blank character in buf, and reture the length.
  	public static int BufLen(byte[] buffer, int len)
  	{
  		int i=0;
  		for(i=0;i<len && buffer[i]!=0;i++);
  		return i;
  	}
}


